% function for importing data from txt files that are build by LabVIEW
% using Keithley 2450 SourceMeter. Format for the files is 5 columns
% containing voltage, current, relative time, date and timestamp.

% This function m-file returns V,I,RelTime,Time (H,M,S) and requires a
% filename as input.

function [V,I,RelTime,Y,MO,D,H,M,S,Time] = import_Keithley(filename)
fid = fopen(filename);
A = textscan(fid,'%s');
fclose(fid);
B = reshape(A{1,1},5,[]).';
V = cellfun(@(x)str2double(x),B(:,1));
I = cellfun(@(x)str2double(x),B(:,2));
RelTime = cellfun(@(x)str2double(x),B(:,3));
formatIn = 'mm/dd/yyyy';
[Y,MO,D,~,~,~] = datevec(B(:,4),formatIn);
[~,~,~,H,M,S] = datevec(B(:,5));
Time = B(:,5);
end